// GameCamera updates the camera and allows the ShakeCamera event to shake the camera
/******************************************************************************/
class GameCamera
{
    GameCamera();
   ~GameCamera();
   
   void Update();
   
   void StartCamShake(Vec2 offset, Vec2 speed) { m_Shaking = true; m_Offset = offset; m_Speed = speed; }
   void StopCamShake() { m_Shaking = false; }
   
   void SetCameraFirstPerson();
   void SetCameraThirdPerson();
   void SetCameraLookAt(Vec cameraPos, Vec lookPosition);
   void SetCameraLookAt(Vec cameraPos, UID trackObject);
   
private:

   bool m_Shaking;
   Vec2 m_Offset, m_Speed;
   
   VIEW_MODE m_View; 
   Game.Obj* m_TrackingObject;
   Vec m_LookPos;
   Vec m_LockedCamPos;
};
/******************************************************************************/
GameCamera::GameCamera() : m_Shaking(false), m_Offset(0), m_Speed(0), m_View(VIEW_TPP), m_TrackingObject(null), m_LookPos(0), m_LockedCamPos(0)
{
   
}
GameCamera::~GameCamera()
{
   
}
/******************************************************************************/
void GameCamera::Update()
{
   Vec finalOffset = 0;
   
   if(m_Shaking)
   {
      flt randomX = Random.f(0, m_Offset.x);
      flt randomY = Random.f(0, m_Offset.y);
     
      // move cam a bit                  //Speed                   //Radius
      finalOffset.x = Cos(Time.time() * (m_Speed.x + randomX))  / (m_Offset.x + randomX);
      finalOffset.y = Sin(Time.time() * (m_Speed.y + randomY))  / (m_Offset.y + randomY);
   }
   
   switch(m_View)
   {
      case VIEW_TPP:
      {    
         Vec playerPos = Players[0].pos();
         Vec camPos = (playerPos + Vec(0, 0.5, 0)) + finalOffset;
         
         Cam.dist = Max(1.0, Cam.dist*ScaleFactor(Ms.wheel()*-0.1)); // update camera distance according to mouse wheel
         Cam.setSpherical(camPos, Players[0].angle.x, Players[0].angle.y, 0, Cam.dist); // set spherical camera looking at player position with given player angles
      } break;
      
      case VIEW_FPP:
      {
         C OrientP *head=Players[0].skel.getSlot("head"); // obtain player "head" skeleton slot (this was created in Object Editor)
         Cam.setPosDir(head.pos + finalOffset, head.dir, head.perp); // set camera from 'head' position, direction and perpendicular to direction
      } break;
      
      case VIEW_LA:
      {
         if(m_TrackingObject != NULL)
         {
            Cam.setFromAt(m_LockedCamPos + finalOffset, m_TrackingObject.pos() + finalOffset);
         }
         else
         {
            Cam.setFromAt(m_LockedCamPos + finalOffset, m_LookPos + finalOffset);
         }
      }  break;
   }
    
   // after setting camera position and angles:
   Cam.updateVelocities().set(); // update camera velocities and activate it 
}
/******************************************************************************/
void GameCamera::SetCameraFirstPerson()
{
   m_View = VIEW_FPP;
   
   m_TrackingObject = NULL;
}
void GameCamera::SetCameraThirdPerson()
{
   m_View = VIEW_TPP;
   
   m_TrackingObject = NULL;
}
void GameCamera::SetCameraLookAt(Vec cameraPos, Vec lookPosition)
{
   m_View = VIEW_LA;
   m_LockedCamPos = cameraPos;
   m_LookPos = lookPosition;
   
   m_TrackingObject = NULL;
}
void GameCamera::SetCameraLookAt(Vec cameraPos, UID trackObject)
{
   m_View = VIEW_LA;
   m_LockedCamPos = cameraPos;
   m_TrackingObject = Game.World.findObjById(trackObject);
   DEBUG_ASSERT(m_TrackingObject != NULL, "tracking object not found");
}
/******************************************************************************/
enum VIEW_MODE // Viewing Mode
{
   VIEW_FPP, // First Person
   VIEW_TPP, // Third Person
   VIEW_LA,  // Look At
   VIEW_NUM, // number of view modes
}